

/*=============================================
SUBIENDO LA FOTO DEL USUARIO
=============================================*/
$(".nuevaFoto").change(function(){

	var imagen = this.files[0];
	
	/*=============================================
  	VALIDAMOS EL FORMATO DE LA IMAGEN SEA JPG O PNG
  	=============================================*/

  	if(imagen["type"] != "image/jpeg" && imagen["type"] != "image/png"){

  		$(".nuevaFoto").val("");

  		 swal({
		      title: "Error al subir la imagen",
		      text: "¡La imagen debe estar en formato JPG o PNG!",
		      type: "error",
		      confirmButtonText: "¡Cerrar!"
		    });

  	}else if(imagen["size"] > 2000000){

  		$(".nuevaFoto").val("");

  		 swal({
		      title: "Error al subir la imagen",
		      text: "¡La imagen no debe pesar más de 2MB!",
		      type: "error",
		      confirmButtonText: "¡Cerrar!"
		    });

  	}else{

  		var datosImagen = new FileReader;
  		datosImagen.readAsDataURL(imagen);

  		$(datosImagen).on("load", function(event){

  			var rutaImagen = event.target.result;

  			$(".previsualizar").attr("src", rutaImagen);

  		})

  	}
})

/*=============================================
EDITAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnEditarUsuario", function(){

	var idUsuario = $(this).attr("idUsuario");
	
	var datos = new FormData();
	datos.append("idUsuario", idUsuario);

	$.ajax({

		url:"ajax/usuarios.ajax.php",
		method: "POST",
		data: datos,
		cache: false,
		contentType: false,
		processData: false,
		dataType: "json",
		success: function(respuesta){
			$("#editarDocumento").val(respuesta["documento"]);
			$("#editarNombre").val(respuesta["nombre"]);
			$("#editarUsuario").val(respuesta["usuario"]);
			$("#editarCelular").val(respuesta["celular"]);
			$("#editarCorreo").val(respuesta["correo"]);
			$("#editarPerfil").html(respuesta["perfil"]);
			$("#editarPerfil").val(respuesta["perfil"]);
			$("#fotoActual").val(respuesta["foto"]);

			$("#passwordActual").val(respuesta["password"]);

			if(respuesta["foto"] != ""){

				$(".previsualizarEditar").attr("src", respuesta["foto"]);

			}else{

				$(".previsualizarEditar").attr("src", "vistas/img/usuarios/default/anonymous.png");

			}

		}

	});

})

/*=============================================
ACTIVAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnActivar", function(){

	var idUsuario = $(this).attr("idUsuario");
	var estadoUsuario = $(this).attr("estadoUsuario");

	var datos = new FormData();
 	datos.append("activarId", idUsuario);
  	datos.append("activarUsuario", estadoUsuario);

  	$.ajax({

	  url:"ajax/usuarios.ajax.php",
	  method: "POST",
	  data: datos,
	  cache: false,
      contentType: false,
      processData: false,
      success: function(respuesta){

      		if(window.matchMedia("(max-width:767px)").matches){

	      		 swal({
			      title: "El usuario ha sido actualizado",
			      type: "success",
			      confirmButtonText: "¡Cerrar!"
			    }).then(function(result) {
			        if (result.value) {

			        	window.location = "usuarios";

			        }


				});

	      	}

      }

  	})

  	if(estadoUsuario == 0){

  		$(this).removeClass('btn-success');
  		$(this).addClass('btn-danger');
  		$(this).html('Desactivado');
  		$(this).attr('estadoUsuario',1);

  	}else{

  		$(this).addClass('btn-success');
  		$(this).removeClass('btn-danger');
  		$(this).html('Activado');
  		$(this).attr('estadoUsuario',0);

  	}

})

/*=============================================
REVISAR SI EL USUARIO YA ESTÁ REGISTRADO
=============================================*/

$("#nuevoUsuario").change(function(){

	$(".alert").remove();

	var usuario = $(this).val();

	var datos = new FormData();
	datos.append("validarUsuario", usuario);

	 $.ajax({
	    url:"ajax/usuarios.ajax.php",
	    method:"POST",
	    data: datos,
	    cache: false,
	    contentType: false,
	    processData: false,
	    dataType: "json",
	    success:function(respuesta){
	    	
	    	if(respuesta){

	    		$("#nuevoUsuario").parent().after('<div class="alert alert-warning">Este usuario ya existe en la base de datos</div>');

	    		$("#nuevoUsuario").val("");

	    	}

	    }

	})
})

/*=============================================
ELIMINAR USUARIO
=============================================*/
$(".tablas").on("click", ".btnEliminarUsuario", function(){

  var idUsuario = $(this).attr("idUsuario");
  var fotoUsuario = $(this).attr("fotoUsuario");
  var usuario = $(this).attr("usuario");

  swal({
    title: '¿Está seguro de borrar el usuario?',
    text: "¡Si no lo está puede cancelar la accíón!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, borrar usuario!'
  }).then(function(result){

    if(result.value){

      window.location = "index.php?ruta=usuarios&idUsuario="+idUsuario+"&usuario="+usuario+"&fotoUsuario="+fotoUsuario;

    }

  })

})



$("#usuarios").click(function() {
  $("#modalAgregarUsuario").modal("show");
});





$(".tablas").on('click', '.btnAgregarUsuario', function(event) {
  event.preventDefault();
  var idusuario = $(this).attr("idusuario");

  var datos = new FormData();
    datos.append("usuarioid", idusuario);

  $("#tablebody2").empty();

    $.ajax({

      url:"ajax/usuarios.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(respuesta){
      	console.log(respuesta);
      	let contenido = "";

      	$("#idusuario").val(respuesta[0]["idusuario"]);
      	$("#nuevoNombreCliente").val(respuesta[0]["nombre"]);
      	$("#nuevoDocumento").val(respuesta[0]["perfil"]);
      	$("#nuevoTelefono").val(respuesta[0]["usuario"]);
        let total = 0;
      	$.each(respuesta, function(index, val) {
          total += parseInt(val["total"]);
      		contenido += `<tr class="filas" id="fila">
						<td >${index+1}</td>
						<td>${val["idservicios"]}</td>
						<td>${val["codigo"]}</td>
            <td>${val["fecha_cobro"]}</td>
						<td>${val["total"]}</td>							
					</tr>`;
      	});

        contenido += `<tr class="filas" id="fila">
            <td ></td>
            <td></td>
            <td></td>
            <td><b>Total</b></td>
            <td><b>${total}</b></td>              
          </tr>`;

      	
      	$(".vistaCronograma").append(contenido);
      	$("#modalAgregarUsuario").modal("toggle");
      	$(".selectReporte").removeAttr('disabled');


       
    }

    })

});

$(".selectReporte").on('change', function(event) {
	event.preventDefault();
	let reporte = $(".selectReporte").val();
	let idusuario = $("#idusuario").val();

	/*var datos = new FormData();
    datos.append("usuarioid", idusuario);
    datos.append("reporte", reporte);*/

     let datos = new FormData();
    datos.append("usuarioids", idusuario);
    datos.append("reporte", reporte);


    $.ajax({

      url:"ajax/usuarios.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
      success:function(resp){
      	console.log("dasddas",resp);

      	let contenido = "";
        let total = 0;

      	$.each(resp, function(index, val) {
          total += parseInt(val["total"]);
      		contenido += `<tr class="filas" id="fila">
						<td >${index+1}</td>
						<td>${val["idservicios"]}</td>
						<td>${val["codigo"]}</td>
						<td>${val["fecha_cobro"]}</td>
            <td>${val["total"]}</td>							
					</tr>`;
      	});

        contenido += `<tr class="filas" id="fila">
            <td ></td>
            <td></td>
            <td></td>
            <td><b>Total</b></td>
            <td><b>${total}</b></td>              
          </tr>`;

      	$("#tablebody2").empty();
      	$(".vistaCronograma").append(contenido);


       
    }

    });

	
	 
});




